<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('colla_withdraws', function (Blueprint $table) {
      $table->id();
      $table->string('type');
      $table->foreignId('user_id')->constrained();
      $table->string('username');
      $table->integer('amount');
      $table->string('status');
      $table->string('description');
      $table->string('reference')->nullable();
      $table->string('user_note')->nullable();
      $table->json('payment_info')->nullable();
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('colla_withdraws');
  }
};
