<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gb_collaborators', function (Blueprint $table) {
            $table->id();
            $table->string('name');            
            $table->string('phone')->nullable();
            $table->unsignedInteger('priority')->default(0); 
            $table->boolean('active')->default(true);   
            $table->text('note')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gb_collaborators');
    }
};
