@extends('admin.layouts.master')
@section('title', 'Đơn hàng của CTV: ' . $ctv->username)

@section('content')
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">
        Đơn hàng Cày Thuê của CTV: {{ $ctv->username }} (ID: {{ $ctv->id }})
      </div>

      <a href="{{ route('admin.boosting.ctv.stats') }}" class="btn btn-secondary btn-sm">
        <i class="fa fa-arrow-left"></i> Quay lại thống kê CTV
      </a>
    </div>

    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center">
          <thead>
            <tr>
              <th>#</th>
              <th>Mã đơn</th>
              <th>Khách hàng</th>
              <th>Trạng thái</th>
              <th>Thanh toán</th>
              <th>Tiền CTV (assigned_payment)</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>

          <tbody>
            @forelse($orders as $order)
              <tr>
                <td>{{ $order->id }}</td>
                <td>#{{ $order->code }}</td>
                <td>{{ $order->username ?? 'N/A' }} (ID: {{ $order->user_id }})</td>
                <td>{{ $order->status }}</td>
                <td>{{ number_format($order->payment ?? 0, 0, ',', '.') }} đ</td>
                <td>{{ number_format($order->assigned_payment ?? 0, 0, ',', '.') }} đ</td>
                <td>{{ $order->created_at }}</td>
              </tr>
            @empty
              <tr>
                <td colspan="7">CTV này chưa nhận đơn nào.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      <div class="mt-3">
        {{ $orders->links() }}
      </div>
    </div>
  </div>
@endsection
