@extends('admin.layouts.master')
@section('title', 'Thống kê Cộng Tác Viên Cày Thuê')

@section('content')
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Thống kê Cộng Tác Viên Cày Thuê</div>
    </div>

    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Tài khoản CTV</th>
              <th>Email CTV</th>
              <th>Số đơn đã nhận</th>
              <th>Số đơn hoàn thành</th>
              <th>Doanh thu</th>
              <th>Thao tác</th>
            </tr>
          </thead>

          <tbody>
            @foreach($ctvs as $index => $ctv)
              @php
                $stat = $statsByCt[$ctv->username] ?? null;
              @endphp
              <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $ctv->username }} (ID: {{ $ctv->id }})</td>
                <td>{{ $ctv->email }}</td>
                <td>{{ $stat->total_orders ?? 0 }}</td>
                <td>{{ $stat->completed_orders ?? 0 }}</td>
                <td>{{ number_format($stat->total_revenue ?? 0, 0, ',', '.') }} đ</td>
                <td>
                  <a href="{{ route('admin.boosting.ctv.orders', $ctv->username) }}" class="btn btn-info btn-sm">
                    Xem đơn đã nhận
                  </a>
                </td>
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
@endsection
