@props(['pageTitle' => 'Default Title', 'postTitle' => null, 'meta_seo' => null])

<!-- Dev By CMSNT.CO | FB.COM/CMSNT.CO | ZALO.ME/0947838128 | MMO Solution -->
<!-- Version: 1.0.1-p1 -->
<!-- Dev Status: Stable -->

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="ltr" class="light layout-boxed null nav-floating horizontalMenu">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="content-language" content="{{ currentLang() === 'vn' ? 'vi' : 'en' }}">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <link rel="canonical" href="{{ url()->current() }}" />

  @hasSection('description')
    <meta name="description" content="@yield('description')">
  @else
    <meta name="description" content="{{ setting('description') }}">
  @endif
  @hasSection('keywords')
    <meta name="keywords" content="@yield('keywords')">
  @else
    <meta name="keywords" content="{{ setting('keywords') }}">
  @endif
  <meta name="author" content="{{ setting('author') }}">
  <meta name="robots" content="index, follow">
  <meta name="googlebot" content="index, follow">
  <meta name="google" content="notranslate">
  <meta name="generator" content="{{ strtoupper($_SERVER['HTTP_HOST']) }}">

  <meta name="application-name" content="{{ setting('title') }}">
  <meta property="og:image" content="{{ asset(setting('logo_share')) }}">
  <meta property="og:image:secure_url" content="{{ asset(setting('logo_share')) }}">
  {{-- <meta property="og:image:width" content="128">
  <meta property="og:image:height" content="128"> --}}
  {{-- <meta property="og:image:type" content="image/png"> --}}
  <meta property="og:image:alt" content="{{ setting('title') }}">
  <meta property="og:title" content="{{ setting('title') }}">
  <meta property="og:site_name" content="{{ setting('title') }}">
  <meta property="og:description" content="{{ setting('description') }}">
  <meta property="og:url" content="{{ url()->current() }}">
  <meta property="og:type" content="website">

  <link rel="shortcut icon" href="{{ asset(setting('favicon')) }}" type="image/x-icon">

  @hasSection('postTitle')
    <title>@yield('postTitle')</title>
  @endif
  @hasSection('title')
    <title>@yield('title') - {{ setting('title') }}</title>
  @else
    @hasSection('pageTitle')
      <title>@yield('pageTitle')</title>
    @else
      <title>{{ setting('title') }}</title>
    @endif
  @endif

  <script src="https://cdn.jsdelivr.net/npm/pace-js@latest/pace.min.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pace-js@latest/pace-theme-default.min.css">

  <link rel="preconnect" href="https://fonts.gstatic.com">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@600;700;800&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Signika:wght@600;700;800&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Play:wght@600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  {{-- Scripts --}}
  <script>
    window.webData = @json([
        'csrfToken' => csrf_token(),
    ]);
    window.userData = @json(auth()->user());
  </script>

  @vite(['resources/css/app.scss', 'resources/js/custom/store.js'])

  @include('layouts.partials.custom-head')

  @stack('css')
  @yield('css')

  {!! Helper::getNotice('header_script') !!}

  <!-- v-translate -->
  <script>
    window.LANG = @json(getLangJson() ?? [])


    window.$__t = function(key) {
      if (window.LANG[key] === undefined) {
        // console.log(key);
      }
      return window.LANG[key] || key;
    }

    window.__defaultLang = '{{ currentLang() }}';
    window.__usdRate = '{{ usdRate() }}';

    window.$formatCurrency = function(number, currency = 'VND', maxinum = 0) {
      return new Intl.NumberFormat('vi-VN', {
        style: 'currency',
        currency: __defaultLang === 'vn' ? 'VND' : 'USD',
        maximumFractionDigits: maxinum,
      }).format(number);
    }

    window.__DEFAULT_THEME = '{{ setting('default_theme', 'light') }}';
  </script>
</head>

<body class="font-inter dashcode-app" id="body_class">
  <div class="app-wrapper">

    <!-- BEGIN: Sidebar Navigation -->
    <x-sidebar-menu />
    <!-- End: Sidebar -->

    @if (theme_config('enable_custom_theme', false))
      <!-- BEGIN: Settings -->
      <x-dashboard-settings />
      <!-- End: Settings -->
    @endif

    <div class="flex min-h-screen flex-col justify-between">
      <div>
        <!-- BEGIN: header -->
        <x-dashboard-header />
        <!-- BEGIN: header -->

        <div class="content-wrapper transition-all duration-150 ltr:ml-0 rtl:mr-0 xl:ltr:ml-[248px] xl:rtl:mr-[248px]" id="content_wrapper">
          <div class="page-content">
            <div class="container-fluid transition-all duration-150" id="page_layout">
              <main id="content_layout">
                <!-- Page Content -->
                <div class="mb-3">
                  @include('components.x-alert')
                </div>

                {{ $slot }}
              </main>
            </div>
          </div>
        </div>
      </div>

      <!-- BEGIN: footer -->
      <x-dashboard-footer />
      <!-- BEGIN: footer -->

    </div>
  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>

  @vite(['resources/js/app.js', 'resources/js/main.js', 'resources/js/functions.js'])

  @php
    $get_gift = Helper::getConfig('get_gift');
  @endphp
  @if (isset($get_gift['status']) && $get_gift['status'] == 1)
    <style type="text/css">
      #bonus {
        position: fixed;
        bottom: 15px;
        left: 15px;
        width: 13%;
        z-index: 1000;
        cursor: pointer;
      }

      #bonus img {
        width: 100%;
      }

      #bonus_login {
        display: block;
        position: fixed;
        bottom: 85px;
        left: 15px;
        width: 13%;
        z-index: 1000;
        cursor: pointer;
      }

      #bonus_login img {
        width: 100%;
      }

      .mobile {
        width: 30% !important;
      }

      @media only screen and (max-width: 640px) {
        #bonus_login {
          width: 40% !important;
          !important;
        }

        #bonus {
          width: 40% !important;
          !important;
        }
      }

      #bonusModal .modal-body p,
      #bonusModal .modal-body b {
        display: inline;
        color: #000
      }
    </style>
    @if (auth()->check() && auth()->user()->received_gift === false)
      <a id="bonus_login" href="javascript:void(0)" onclick="receiveGift()" title="Click để nhận thưởng!" class="">
        <img src="{{ $get_gift['image'] ?? '' }}" width="{{ $get_gift['width'] ?? '500' }}px" @isset($get_gift['height']) height="{{ $get_gift['height'] }}px" @endisset>
      </a>
      <script>
        function receiveGift() {
          axios.post('/api/users/gift-rewards/claim').then((response) => {
            Swal.fire('Chúc Mừng!', response.data.message, 'success').then(() => {
              location.reload();
            });
          }).catch(error => {
            Swal.fire('Thất bại!', $catchMessage(error), 'error');
          });
        }
      </script>
    @elseif(!auth()->check())
      <a id="bonus_login" href="{{ route('login') }}" title="Click để nhận thưởng!" class="">
        <img src="{{ $get_gift['image'] ?? '' }}" width="{{ $get_gift['width'] ?? '500' }}px" @isset($get_gift['height']) height="{{ $get_gift['height'] }}px" @endisset>
      </a>
    @endif
  @endif

  @stack('scripts')
  @yield('scripts')

  {!! Helper::getNotice('footer_script') !!}

  @if (currentLang() !== 'en')
    <script>
      window.gtranslateSettings = {
        "default_language": "vi",
        "native_language_names": true,
        "globe_color": "#66aaff",
        "wrapper_selector": ".gtranslate_wrapper",
        "flag_size": 28,
        "alt_flags": {
          "en": "usa"
        },
        "globe_size": 24
      }
    </script>
    <script src="https://cdn.gtranslate.net/widgets/latest/globe.js" defer></script>
  @endif
</body>

</html>

<!-- Dev By CMSNT.CO | FB.COM/CMSNT.CO | ZALO.ME/0947838128 | MMO Solution -->
