<?php $__env->startSection('content'); ?>
  <style>
    .card-stats h3 {
      color: #9A3B3B;
      font-size: 36px;
    }

    .card-stats h6 {
      color: #9A3B3B;
      font-size: 18px;
    }
  </style>
  <div>
    <h3>Thống Kê Tài Khoản CTV</h3>
    <div class="row">
      <?php $__currentLoopData = $stats['users']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
          <div class="card">
            <div class="card-body">
              <div class="text-center card-stats">
                <h3><?php echo e(Helper::formatCurrency($value)); ?></h3>
                <h5><?php echo e($key); ?></h5>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <h3>Thống Kê Đơn Tài Khoản</h3>
    <div class="row">
      <?php $__currentLoopData = $stats['accounts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
          <div class="card">
            <div class="card-body">
              <div class="text-center card-stats">
                <h3><?php echo e(number_format($value)); ?></h3>
                <h5><?php echo e($key); ?></h5>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <h3>Thống Kê Đơn Vật Phẩm</h3>
    <div class="row">
      <?php $__currentLoopData = $stats['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
          <div class="card">
            <div class="card-body">
              <div class="text-center card-stats">
                <h3><?php echo e(number_format($value)); ?></h3>
                <h5><?php echo e($key); ?></h5>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <h3>Thống Kê Đơn Cày Thuê</h3>
    <div class="row">
      <?php $__currentLoopData = $stats['boostings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
          <div class="card">
            <div class="card-body">
              <div class="text-center card-stats">
                <h3><?php echo e(number_format($value)); ?></h3>
                <h5><?php echo e($key); ?></h5>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <h3>Thống Kê Doanh Thu</h3>
    <div class="row">
      <?php $__currentLoopData = $stats['transactions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
          <div class="card">
            <div class="card-body">
              <div class="text-center card-stats">
                <h3><?php echo e(Helper::formatCurrency($value)); ?></h3>
                <h5><?php echo e($key); ?></h5>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="card custom-card">
          <div class="card-header justify-content-between">
            <div class="card-title">Yêu cầu rút tiền</div>
          </div>
          <div class="card-body">
            <form action="<?php echo e(route('staff.withdraws.store')); ?>" method="POST" id="form-withdraw">
              <div class="mb-3">
                <label for="amount" class="form-label">Số tiền rút</label>
                <input type="number" class="form-control" id="amount" name="amount" value="10000" required>
              </div>
              <div class="mb-4">
                <label for="bank_name" class="form-label"><?php echo e(__t('Ngân Hàng')); ?></label>
                <select name="bank_name" id="bank_name" class="form-control">
                  <option value=""><?php echo e(__t('Chọn Ngân Hàng Rút')); ?></option>
                  <?php $__currentLoopData = Helper::getListBank(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($bank['code']); ?>"><?php echo e($bank['name']); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="row mb-4">
                <div class="col-md-6">
                  <label for="account_number" class="form-label"><?php echo e(__t('Số Tài Khoản')); ?></label>
                  <input type="text" class="form-control" id="account_number" name="account_number" value="<?php echo e(old('account_number')); ?>" placeholder="<?php echo e(__t('Nhập số tài khoản')); ?>">
                </div>
                <div class="col-md-6">
                  <label for="account_name" class="form-label"><?php echo e(__t('Chủ Tài Khoản')); ?></label>
                  <input type="text" class="form-control" id="account_name" name="account_name" value="<?php echo e(old('account_name')); ?>" placeholder="<?php echo e(__t('Nhập tên chủ tài khoản')); ?>">
                </div>
              </div>
              <div class="mb-4">
                <label for="user_note" class="form-label"><?php echo e(__t('Ghi Chú')); ?></label>
                <textarea name="user_note" id="user_note" class="form-control" rows="3" placeholder="<?php echo e(__t('Nhập ghi chú cho admin nếu có')); ?>"><?php echo e(old('user_note')); ?></textarea>
              </div>
              <div class="mb-3">
                <button class="btn btn-primary w-full large w-100" type="submit"><?php echo e(__t('Rút Tiền Ngay')); ?></button>
              </div>
            </form>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card custom-card">
          <div class="card-header justify-content-between">
            <div class="card-title">Lịch sử yêu cầu</div>
          </div>
          <div class="card-body">
            <div class="table-responsive" style="padding: 5px">
              <table class="display table table-bordered table-stripped text-nowrap datatable" id="basic-1">
                <thead>
                  <tr>
                    <td>#</td>
                    <td>Số tiền</td>
                    <td>Ngân hàng</td>
                    <td>Số tài khoản</td>
                    <td>Trạng thái</td>
                    <td>Thời gian</td>
                    <td>Ghi chú</td>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($value->id); ?></td>
                      <td><?php echo e(Helper::formatCurrency($value->amount)); ?></td>
                      <td><?php echo e($value->payment_info['bank_name'] ?? ''); ?></td>
                      <td><?php echo e($value->payment_info['account_name'] ?? ''); ?></td>
                      <td><?php echo Helper::formatStatus($value->status); ?></td>
                      <td><?php echo e($value->created_at); ?></td>
                      <td><?php echo e($value->user_note); ?></td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      <div class="col-md-12">
        <div class="card custom-card">
          <div class="card-header justify-content-between">
            <div class="card-title">Danh sách giao dịch</div>
          </div>
          <div class="card-body">
            <div class="table-responsive theme-scrollbar" style="padding: 10px">
              <table class="display table table-bordered table-stripped text-nowrap datatable" id="basic-1">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Tài khoản</th>
                    <th>Giao dịch</th>
                    <th>Mã giao dịch</th>
                    <th>Số dư trước</th>
                    <th>Số tiền</th>
                    <th>Số dư sau</th>
                    <th>Nội dung</th>
                    <th>Trạng thái</th>
                    <th>Thời gian</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($value->id); ?></td>
                      <td><?php echo e($value->username); ?></td>
                      <td><?php echo e($value->type); ?></td>
                      <td><?php echo e($value->reference); ?></td>
                      <td><?php echo e(Helper::formatCurrency($value->balance_before)); ?></td>
                      <td><?php echo e(Helper::formatCurrency($value->amount)); ?></td>
                      <td><?php echo e(Helper::formatCurrency($value->balance_after)); ?></td>
                      <td><?php echo e($value->description); ?></td>
                      <td><?php echo Helper::formatStatus($value->status); ?></td>
                      <td><?php echo e($value->created_at); ?></td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    $("#form-withdraw").submit(async e => {
      e.preventDefault();

      const action = $(e.target).attr('action'),
        button = $(e.target).find('button[type="submit"]')
      payload = $formDataToPayload(new FormData(e.target));

      const confirm = await Swal.fire({
        title: 'Xác Nhận',
        html: `Bạn muốn rút <b>${$formatNumber(payload.amount)} VNĐ</b> về <b>ngân hàng</b> đúng không?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Xác Nhận',
        cancelButtonText: 'Hủy',
      })

      if (!confirm.isConfirmed) return

      $setLoading(button)

      axios.post(action, payload).then(({
        data: result
      }) => {
        Swal.fire('Thành Công', result.message, 'success').then(() => location.reload())
      }).catch(e => {
        Swal.fire('Thất Bại', $catchMessage(e), 'error')
      }).finally(() => {
        $removeLoading(button)
      })
    })
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('staff.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Downloads/don1/resources/views/staff/dashboard.blade.php ENDPATH**/ ?>