<?php $__env->startSection('title', 'Admin: Invoices Management'); ?>
<?php $__env->startSection('content'); ?>
  <div class="mb-3 alert alert-danger">
    Để sử dụng chức năng nạp tiền bằng hóa đơn (qua ngân hàng) vui lòng CRON link này: <a href="<?php echo e(route('cron.deposit.check', ['dp_type' => 'invoice', 'type' => 'BANK_KEY'])); ?>"
      target="_blank"><?php echo e(route('cron.deposit.check', ['dp_type' => 'invoice', 'type' => 'BANK_KEY'])); ?> [BANK_KEY=acb, vietcombank... tương tự trong trang cài đặt apis]</a>
    | 2 phút / lần
  </div>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý hoá đơn</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-nowrap datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Thao tác</th>
              <th>Mã hoá đơn</th>
              <th>Số tiền</th>
              <th>Loại tiền tệ</th>
              <th>Loại giao dịch</th>
              <th>Khách hàng</th>
              <th>Trạng thái</th>
              <th>Ngân hàng</th>
              <th>Còn lại</th>
              <th>Ghi chú</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <?php if($item->status === 'processing'): ?>
                    <a href="javascript:setStatus(<?php echo e($item->id); ?>, 'paid')" class="shadow text-white badge bg-success-gradient"><i class="fas fa-thumbs-up"></i></a>
                    <a href="javascript:setStatus(<?php echo e($item->id); ?>, 'cancelled')" class="shadow text-white badge bg-danger-gradient"><i class="fas fa-trash"></i></a>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->code); ?></td>
                <td><?php echo e(Helper::formatCurrency($item->amount)); ?></td>
                <td><?php echo e($item->currency); ?></td>
                <td><?php echo e(Helper::formatTransType($item->type)); ?></td>
                <td><?php echo e($item->username); ?></td>
                <td><?php echo Helper::formatStatus($item->status); ?></td>
                <td>
                  <?php $paymentDetail = ($item->payment_details) ?>

                  <?php if($paymentDetail): ?>
                    <span class="text-danger"><?php echo e($paymentDetail['name'] ?? 'N/A'); ?>|<?php echo e($paymentDetail['number'] ?? 'N/A'); ?></span>
                  <?php else: ?>
                    <span class="text-danger">-</span>
                  <?php endif; ?>

                </td>
                <td>
                  <?php if($item->is_expired): ?>
                    <span class="text-danger">-</span>
                  <?php else: ?>
                    <?php echo e($item->expired_str); ?>

                  <?php endif; ?>
                </td>

                <td><?php echo e($item->description); ?></td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

  <script>
    const setStatus = async (id, type) => {
      let simpleText = type === 'paid' ? 'đã thanh toán' : 'đã hủy'

      const confirm = await Swal.fire({
        title: 'Bạn có chắc chắn?',
        text: `Chuyển trạng thái hoá đơn này sang ${simpleText}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Đồng ý',
        cancelButtonText: 'Hủy',
      })

      if (confirm.isConfirmed !== true)
        return

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.invoices.update')); ?>', {
          id,
          type
        })

        Swal.fire("Thành công!", result.message, "success").then(() => {
          window.location.reload()
        })

      } catch (error) {
        Swal.fire("Thất bại", $catchMessage(error), "error")
      }

    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/invoices/index.blade.php ENDPATH**/ ?>