<?php $__env->startSection('title', 'Admin: Posts Management'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý bài viết</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Ưu tiên</th>
              <th>Thao tác</th>
              <th>Ảnh bìa</th>
              <th>Bài viết</th>
              <th>Trạng thái</th>
              <th>Người viết</th>
              <th>Ngày viết</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td><?php echo e($item->priority); ?></td>
                <td>
                  <a href="<?php echo e(route('admin.posts.show', ['id' => $item->id])); ?>" class="badge bg-primary-gradient me-1"><i class="fa fa-pencil"></i> sửa</a>
                  <a href="javascript:deleteRow(<?php echo e($item->id); ?>)" class="badge bg-danger-gradient me-1"><i class="fa fa-trash"></i> xoá</a>
                </td>
                <td>
                  <img src="<?php echo e(asset($item->thumbnail)); ?>" width="25">
                </td>
                <td><?php echo e($item->title); ?></td>
                <td>
                  <?php if($item->status == 1): ?>
                    <span class="text-success">Đang hiện</span>
                  <?php else: ?>
                    <span class="text-danger">Đang ẩn</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->author_name); ?></td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <a href="<?php echo e(route('admin.posts.create')); ?>" class="btn btn-primary-gradient">Tạo bài viết mới</a>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.posts.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/posts/index.blade.php ENDPATH**/ ?>