<?php $__env->startSection('title', __t($pageTitle)); ?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
  <section class="space-y-6">
    <div class="mx-auto grid max-w-5xl grid-cols-1 gap-6 md:grid-cols-3">
      <div class="col-span-1 md:col-span-3 card">
        <div class="card-body flex flex-col p-6">
          <div class="card-text h-full space-y-4">
            <?php echo Helper::getNotice('page_deposit'); ?>

          </div>
        </div>
      </div>
      <?php if($cardOn): ?>
        <div>
          <div class="mb-2 rounded-b-none border border-none bg-transparent p-3 hidden md:block">
            <img src="/images/svg/dollar.svg" alt="Nap The Cao" class="mx-auto w-[90px] cursor-pointer object-cover">
          </div>
          <div class="rounded-lg bg-[#025464] p-4 pb-5">
            <form class="space-y-3" id="form-sendcard">
              <div class="input-area">
                <label for="telco" class="form-label !text-white"><?php echo e(__t('Loại thẻ')); ?></label>
                <select class="form-control" id="telco" name="telco" required>
                  <option value=""><?php echo e(__t('Chọn loại thẻ')); ?></option>
                  <option value="VIETTEL">Viettel - <?php echo e(__t('Phí')); ?> <?php echo e($fees['VIETTEL'] ?? 20); ?>%</option>
                  <option value="VINAPHONE">Vinaphone - <?php echo e(__t('Phí')); ?> <?php echo e($fees['VINAPHONE'] ?? 20); ?>%</option>
                  <option value="MOBIFONE">Mobifone - <?php echo e(__t('Phí')); ?> <?php echo e($fees['MOBIFONE'] ?? 20); ?>%</option>
                  <option value="ZING">Zing Card - <?php echo e(__t('Phí')); ?> <?php echo e($fees['ZING'] ?? 20); ?>%</option>
                  <option value="GARENA">Garena - <?php echo e(__t('Phí')); ?> <?php echo e($fees['GARENA'] ?? 20); ?>%</option>
                  <option value="VNMOBI">Vietnamobile - <?php echo e(__t('Phí')); ?> <?php echo e($fees['VNMOBI'] ?? 20); ?>%</option>
                </select>
              </div>
              <div class="input-area">
                <label for="amount" class="form-label !text-white"><?php echo e(__t('Mệnh giá')); ?></label>
                <select class="form-control" id="amount" name="amount" required>
                  <option value=""><?php echo e(__t('Chọn mệnh giá')); ?></option>
                  <option value="10000">10.000 đ</option>
                  <option value="20000">20.000 đ</option>
                  <option value="30000">30.000 đ</option>
                  <option value="50000">50.000 đ</option>
                  <option value="100000">100.000 đ</option>
                  <option value="200000">200.000 đ</option>
                  <option value="300000">300.000 đ</option>
                  <option value="500000">500.000 đ</option>
                  <option value="1000000">1.000.000 đ</option>
                </select>
              </div>
              <div class="input-area">
                <label for="serial" class="form-label !text-white"><?php echo e(__t('Số serial')); ?></label>
                <input type="text" class="form-control" id="serial" name="serial" placeholder="<?php echo e(__t('Nhập số serial')); ?>" required>
              </div>
              <div class="input-area">
                <label for="code" class="form-label !text-white">Mã thẻ</label>
                <input type="text" class="form-control" name="code" id="code" placeholder="<?php echo e(__t('Nhập mã thẻ')); ?>" required>
              </div>
              <div class="text-center text-[16px] text-lime-500">
                <i><?php echo e(__t('Nếu Chọn Sai Mệnh Giá Sẽ Bị Mất Thẻ!')); ?></i>
              </div>
              <div class="input-area">
                <button class="btn btn-sm btn-success w-full" type="submit"><?php echo e(__t('Gửi để nhận')); ?> <span class="real_amount">0đ</span></button>
              </div>
            </form>
          </div>
        </div>
      <?php endif; ?>
      <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div>
          <div class="rounded-b-none border border-none bg-transparent p-4">
            <img src="<?php echo e(asset($bank->image)); ?>" alt="<?php echo e($bank->name); ?>" class="mx-auto w-[90px] cursor-pointer object-cover">
          </div>
          <div class="space-y-2 rounded-lg bg-[#002B5B] p-4 text-[18px] font-bold text-white">
            <div class="flex flex-wrap justify-between">
              <span><?php echo e(ucfirst($bank->name)); ?>:</span>
              <span class="copy cursor-pointer" data-clipboard-text="<?php echo e($bank->number); ?>"><?php echo e($bank->number); ?></span>
            </div>
            <div class="flex flex-wrap justify-between">
              <span><?php echo e(__t('Chủ TK')); ?></span>
              <span><?php echo e($bank->owner); ?></span>
            </div>
            <div class="flex flex-wrap justify-between">
              <span><?php echo e(__t('Nội Dung')); ?></span>
              <span class="copy cursor-pointer" data-clipboard-text="<?php echo e($deposit_prefix); ?>"><?php echo e($deposit_prefix); ?></span>
            </div>
            <div class="text-center">
              <?php echo e(__t('Nhập đúng nội dung tiền tự động cộng trong vài phút')); ?>

            </div>
            <div>
              <?php if(str_contains(strtolower($bank->name), 'momo')): ?>
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=2|99|<?php echo e($bank->number); ?>|||0|0|0|<?php echo e($deposit_prefix); ?>|transfer_myqr" class="mx-auto w-full rounded-lg object-fill">
              <?php else: ?>
                <img src="https://api.vietqr.io/<?php echo e(strtolower($bank->name)); ?>/<?php echo e($bank->number); ?>/0/<?php echo e($deposit_prefix); ?>/qronly2.jpg?accountName=<?php echo e($bank->owner); ?>&bankName=<?php echo e($bank->name); ?>"
                  class="mx-auto w-full rounded-lg object-fill">
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </section>

  <?php $__env->startPush('scripts'); ?>
    <script type="module">
      const CARD_FEES = <?php echo json_encode($fees, 15, 512) ?>;

      $("#form-sendcard #amount").change((e) => {
        sumAmount();
      })

      $("#form-sendcard #telco").change((e) => {
        sumAmount();
      })

      const sumAmount = () => {
        const telco = $("#form-sendcard #telco").val();
        const amount = $("#form-sendcard #amount").val();

        if (amount) {
          const real_amount = amount - (amount * CARD_FEES[telco] / 100);

          console.log(real_amount);
          $("#form-sendcard .real_amount").text($formatCurrency(real_amount));
        } else {
          $("#form-sendcard .real_amount").text($formatCurrency(0));
        }
      }

      $("#form-sendcard").submit(async (e) => {
        e.preventDefault();

        const action = e.target.action,
          method = e.target.method,
          payload = $formDataToPayload(new FormData(e.target));

        $showLoading();

        try {
          const {
            data: result
          } = await axios.post('/api/accounts/send-card', payload)

          Swal.fire('Thành công', result.message, 'success').then(() => {
            e.target.reset();
          })
        } catch (error) {
          Swal.fire('Thất bại', error.response.data.message, 'error')
        }
      })
    </script>
  <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /home/arowne0zfj6/public_html/resources/views/account/deposits/index.blade.php ENDPATH**/ ?>