<?php
  $primaryColor = setting('primary_color', '#ff5d05');

  $ringOffsetShadow = 'var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)';
  $ringShadow = 'var(--tw-ring-inset) 0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color)';
  $defaultShadow = '0 0 #0000';
  $ringOpacity = 0.8;
  $ringOffsetWidth = '1px';
?>

<style>
  * {
    font-family: 'Signika', sans-serif;
    letter-spacing: 0.5px;
  }

  :root {
    --primary-color: <?php echo e($primaryColor); ?>;
  }

  .text-primary {
    color: var(--primary-color) !important;
  }

  .shadow-primary {
    --tw-ring-offset-shadow: <?php echo e($ringOffsetShadow); ?>;
    --tw-ring-shadow: <?php echo e($ringShadow); ?>;
    box-shadow: <?php echo e($defaultShadow); ?> !important;
    --tw-ring-opacity: <?php echo e($ringOpacity); ?>;
    --tw-ring-offset-width: <?php echo e($ringOffsetWidth); ?>;
  }

  .btn-primary,
  .bg-primary,
  .ant-btn-primary {
    background-color: var(--primary-color) !important;
  }

  .btn-outline-primary {
    border-color: var(--primary-color) !important;
    color: var(--primary-color) !important;
  }

  .btn-primary:hover {
    box-shadow: var(--primary-color) !important;
  }

  .border-primary {
    border-color: var(--primary-color) !important;
  }

  .main-menu>ul>li.menu-item-has-children>ul.sub-menu li a:hover {
    color: var(--primary-color) !important;
  }

  .main-menu>ul>li>a:hover {
    color: var(--primary-color) !important;
  }

  .main-menu>ul>li:hover>a .icon-box {
    color: var(--primary-color) !important;
  }

  .main-menu>ul>li:hover>a .text-box {
    color: var(--primary-color) !important;
  }

  .btn-primary:hover {
    --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
    --tw-ring-shadow: var(--tw-ring-inset) 0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--primary-color);
    box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0 #0000) !important;
    --tw-ring-opacity: 0.8;
    --tw-ring-offset-width: 1px;
  }

  ::-webkit-scrollbar {
    width: 5px;
  }

  ::-webkit-scrollbar-track {
    background: #282a38;
  }

  ::-webkit-scrollbar-thumb {
    background: var(--primary-color);
  }

  ::-webkit-scrollbar-thumb:hover {
    background: #e23388;
  }

  ::selection {
    background: var(--primary-color);
    color: #fff;
  }

  .category-name {
    text-shadow: 0 0 3px #fff, 0 0 3px var(--primary-color);
  }
</style>

<?php if(theme_config('background_color')): ?>
  <style>
    .app-wrapper {
      background-color: <?php echo e(theme_config('background_color')); ?>;
    }
  </style>
<?php elseif(theme_config('background_image')): ?>
  <style>
    body {
      background-image: url('<?php echo e(theme_config('background_image')); ?>');
      background-size: cover;
      background-attachment: fixed;
      background-position: center;
      background-repeat: no-repeat;
    }
  </style>
<?php endif; ?>
<script>
  window.colorPrimary = "<?php echo e($primaryColor); ?>";
</script>
<?php /**PATH /home/arowne0zfj6/public_html/resources/views/layouts/partials/custom-head.blade.php ENDPATH**/ ?>