<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Đơn hàng Cày thuê - Đã nhận</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-nowrap text-center datatablez">
          <thead>
            <tr>
              <th>#</th>
              <th>Thao tác</th>
              <th>Mã đơn</th>
              <th>Dịch vụ</th>
              <th>Thanh toán</th>
              <th>Trong nhóm</th>
              <th>Trạng thái</th>
              <th>Ghi chú</th>
              <th>Thời gian</th>
              <th>Ngày nhận</th>
              <th>Ngày xong</th>
              <th>Tiền nhận</th>
              <th>-</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $claimedOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <?php if(in_array($item->status, ['Assigned', 'Processing'])): ?>
                    <a href="javascript:void(0)" class="shadow btn btn-primary btn-xs sharp me-1" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>"><i class="fa fa-edit"></i> Edit</a>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->code); ?></td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e(Helper::formatCurrency($item->payment)); ?></td>
                <td><?php echo e($item->group?->name ?? '-'); ?></td>
                <td><?php echo Helper::formatStatus($item->status); ?></td>
                <td><?php echo e($item->order_note); ?></td>
                <td><?php echo e($item->created_at); ?></td>
                <td><?php echo e($item->assigned_at); ?></td>
                <td><?php echo e($item->assigned_completed ?? '-'); ?></td>
                <td><?php echo e($item->assigned_payment > 0 ? Helper::formatCurrency($item->assigned_payment) : '-'); ?></td>
                <td>
                  <?php if($item->assigned_status === 'Completed'): ?>
                    <span class="badge bg-success">Đã nhận</span>
                  <?php elseif($item->assigned_status === 'WaitPayment'): ?>
                    <span class="badge bg-warning">Chờ duyệt</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Chưa nhận</span>
                  <?php endif; ?>
                </td>
              </tr>

              <?php if(in_array($item->status, ['Assigned', 'Completed', 'Processing'])): ?>
                <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                  <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Cập nhật đơn hàng #<?php echo e($item->id); ?></h5>
                        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                      </div>
                      <div class="modal-body">
                        <div class="alert alert-danger mb-3">Sau khi hoàn thành đơn, hệ thống sẽ kiểm tra và trả hoa hồng sau 3-5 ngày</div>
                        <form action="<?php echo e(route('staff.orders.boostings.update', ['id' => $item->id])); ?>" method="POST" enctype="multipart/form-data">
                          <?php echo csrf_field(); ?>
                          <div class="mb-3">
                            <label for="name" class="form-label">Dịch vụ</label>
                            <input type="text" id="name" name="name" class="form-control" value="<?php echo e($item->name); ?>" disabled>
                          </div>
                          <div class="row mb-3">
                            <div class="col-md-4">
                              <label for="code" class="form-label">Mã đơn</label>
                              <input type="text" id="code" name="code" class="form-control" value="<?php echo e($item->code); ?>" disabled>
                            </div>
                            <div class="col-md-4">
                              <label for="payment" class="form-label">Thanh toán</label>
                              <input type="text" id="payment" name="payment" class="form-control" value="<?php echo e(Helper::formatCurrency($item->payment)); ?>" disabled>
                            </div>
                            <div class="col-md-4">
                              <label for="assigned_payment" class="form-label">Có thể nhận</label>
                              <input type="text" id="assigned_payment" name="assigned_payment" class="form-control" value="<?php echo e(Helper::formatCurrency((float) (($item->payment * $user->colla_percent) / 100))); ?>"
                                disabled>
                            </div>
                          </div>
                          <?php if($item->type === 'addfriend'): ?>
                            <div class="mb-3">
                              <label for="input_ingame" class="form-label">Danh sách In-Game</label>
                              <textarea class="form-control" id="input_ingame" name="input_ingame" rows="3" disabled><?php echo e(implode("\n", $item->ingame_list ?? [])); ?></textarea>
                            </div>
                            <div class="mb-3">
                              <label for="input_user" class="form-label">Tài khoản nhận</label>
                              <input type="text" id="input_user" name="input_user" class="form-control" value="<?php echo e($item->input_user ?? '-KHÔNG CÓ-'); ?>" disabled>
                            </div>
                          <?php else: ?>
                            <div class="mb-3 row">
                              <div class="col-md-4">
                                <label for="input_user" class="form-label">Tài khoản</label>
                                <input type="text" id="input_user" name="input_user" class="form-control" value="<?php echo e($item->input_user ?? '-KHÔNG CÓ-'); ?>" disabled>
                              </div>
                              <div class="col-md-4">
                                <label for="input_pass" class="form-label">Mật khẩu</label>
                                <input type="text" id="input_pass" name="input_pass" class="form-control" value="<?php echo e($item->input_pass ?? '-KHÔNG CÓ-'); ?>" disabled>
                              </div>
                              <div class="col-md-4">
                                <label for="input_auth" class="form-label">Đăng nhập</label>
                                <input type="text" id="input_auth" name="input_auth" class="form-control" value="<?php echo e($item->input_auth ?? '-KHÔNG CÓ-'); ?>" disabled>
                              </div>
                              <div class="col-md-4">
                                <label for="input_extra" class="form-label">Máy chủ ( Server )</label>
                                <input type="text" id="input_extra" name="input_extra" class="form-control" value="<?php echo e($item->input_extra ?? '-KHÔNG CÓ-'); ?>" disabled>
                              </div>
                              <div class="col-md-4">
                                <label for="input_quantity" class="form-label">Số lượng</label>
                                <input type="text" id="input_quantity" name="input_quantity" class="form-control" value="<?php echo e($item->input_quantity ?? '-KHÔNG CÓ-'); ?>" disabled>
                              </div>
                            </div>
                          <?php endif; ?>
                          <div class="mb-3">
                            <label for="admin_note" class="form-label">Ghi chú admin</label>
                            <textarea class="form-control" id="admin_note" name="admin_note" rows="3"><?php echo e($item->admin_note); ?></textarea>
                          </div>
                          <div class="mb-3">
                            <label for="order_note" class="form-label">Ghi chú khách</label>
                            <textarea class="form-control" id="order_note" name="order_note" rows="3"><?php echo e($item->order_note); ?></textarea>
                          </div>
                          <div class="mb-3">
                            <label for="status" class="form-label">Trạng thái</label>
                            <select class="form-select" id="status" name="status" required>
                              <option value="Assigned" <?php echo e($item->status === 'Assigned' ? 'selected' : ''); ?>>Đã nhận đơn</option>
                              <option value="Processing" <?php echo e($item->status === 'Processing' ? 'selected' : ''); ?>>Đang xử lý</option>
                              <option value="Completed" <?php echo e($item->status === 'Completed' ? 'selected' : ''); ?>>Hoàn thành</option>
                              <option value="Cancelled" <?php echo e($item->status === 'Cancelled' ? 'selected' : ''); ?>>Đã hủy / Hoàn</option>
                            </select>
                          </div>
                          <div class="mb-3">
                            <button class="btn btn-primary">Cập nhật</button>
                          </div>
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <div class="d-flex justify-content-center">
        <?php echo e($claimedOrders->links()); ?>

      </div>
    </div>
  </div>
  <div class="card">
    <div class="card-header">
      <h4>Đơn hàng cày thuê - chưa nhận</h4>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-nowrap text-center datatablez">
          <thead>
            <tr>
              <th>#</th>
              <th>Thao tác</th>
              <th>Mã đơn</th>
              <th>Dịch vụ</th>
              <th>Thanh toán</th>
              <th>Trong nhóm</th>
              <th>Trạng thái</th>
              <th>Ghi chú</th>
              <th>Thời gian</th>
              <th>Ngày nhận</th>
              <th>Ngày xong</th>
              <th>Tiền nhận</th>
              <th>-</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $pendingOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <?php if($item->status === 'Pending'): ?>
                    <a href="javascript:void(0)" class="shadow btn btn-danger btn-xs sharp me-1" onclick="claimOrder(<?php echo e($item->id); ?>)"><i class="fa fa-database"></i> Claim</a>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->code); ?></td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e(Helper::formatCurrency($item->payment)); ?></td>
                <td><?php echo e($item->group?->name ?? '-'); ?></td>
                <td><?php echo Helper::formatStatus($item->status); ?></td>
                <td><?php echo e($item->order_note); ?></td>
                <td><?php echo e($item->created_at); ?></td>
                <td><?php echo e($item->assigned_at); ?></td>
                <td><?php echo e($item->assigned_completed ?? '-'); ?></td>
                <td><?php echo e($item->assigned_payment > 0 ? Helper::formatCurrency($item->assigned_payment) : '-'); ?></td>
                <td>
                  <?php if($item->assigned_status === 'Completed'): ?>
                    <span class="badge bg-success">Đã nhận</span>
                  <?php elseif($item->assigned_status === 'WaitPayment'): ?>
                    <span class="badge bg-warning">Chờ duyệt</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Chưa nhận</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <div class="d-flex justify-content-center">
        <?php echo e($pendingOrders->links()); ?>

      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script>
    const claimOrder = async (id) => {
      const confirm = await Swal.fire({
        title: 'Bạn có chắc chắn chứ?',
        text: "Bạn không được tự ý huỷ đơn này khi đã nhận!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Nhận',
        cancelButtonText: 'Hủy'
      })

      if (!confirm.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('staff.orders.boostings.claim')); ?>', {
          id
        });

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('staff.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/staff/orders/boostings.blade.php ENDPATH**/ ?>