<?php $__env->startSection('title', 'Admin: Items Orders'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý đơn hàng cày thuê</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Thao tác</th>
              <th>Mã đơn</th>
               <th>Số lượng</th>
              <th>Dịch vụ</th>
              <th>Trong nhóm</th>
              <th>Tài khoản</th>
              <th>Thanh toán</th>
              <th>Trạng thái</th>
              <th>Ghi chú</th>
              <th>Thời gian</th>
              <th>Cập nhật</th>

              <th>CTV Nhận</th>
              <th>Ngày nhận</th>
              <th>Ngày xong</th>
              <th>Tiền nhận</th>
              <th>-</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <a href="javascript:void(0)" class="shadow btn btn-primary btn-xs sharp me-1" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>">sửa</a>
                </td>
                <td><?php echo e($item->code); ?></td>
                <td><?php echo e($item->input_quantity); ?></td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e($item->group?->name ?? '-'); ?></td>
                <td><?php echo e($item->username); ?></td>
                <td><?php echo e(Helper::formatCurrency($item->payment)); ?></td>
                <td><?php echo Helper::formatStatus($item->status); ?></td>
                <td><?php echo e($item->order_note); ?></td>
                <td><?php echo e($item->created_at); ?></td>
                <td><?php echo e($item->updated_at); ?></td>

                <td><?php echo e($item->assigned_to ?? 'Chưa Gán'); ?></td>
                <td><?php echo e($item->assigned_at); ?></td>
                <td><?php echo e($item->assigned_completed ?? '-'); ?></td>
                <td><?php echo e($item->assigned_payment > 0 ? Helper::formatCurrency($item->assigned_payment) : '-'); ?></td>
                <td>
                  <?php if($item->assigned_status === 'Completed'): ?>
                    <span class="badge bg-success">Đã nhận</span>
                  <?php elseif($item->assigned_status === 'WaitPayment'): ?>
                    <span class="badge bg-warning">Chờ duyệt</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Chưa nhận</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer"></div>
  </div>

  <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Cập nhật nhóm #<?php echo e($item->id); ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form action="<?php echo e(route('admin.boosting.orders.update', ['id' => $item->id])); ?>" method="POST" enctype="multipart/form-data" class="default-form">
              <?php echo csrf_field(); ?>
              <div class="mb-3">
                <label for="name" class="form-label">Dịch vụ</label>
                <input type="text" id="name" name="name" class="form-control" value="<?php echo e($item->name); ?>" disabled>
              </div>
              <div class="row mb-3">
                <div class="col-md-6">
                  <label for="code" class="form-label">Mã đơn</label>
                  <input type="text" id="code" name="code" class="form-control" value="<?php echo e($item->code); ?>" disabled>
                </div>
                <div class="col-md-6">
                  <label for="payment" class="form-label">Thanh toán</label>
                  <input type="text" id="payment" name="payment" class="form-control" value="<?php echo e(Helper::formatCurrency($item->payment)); ?>" disabled>
                </div>
              </div>
              <?php if($item->type === 'addfriend'): ?>
                <?php
                  $ingame = '';
                  foreach ($item->input_ingame as $ig) {
                      $ingame .= $ig . "\n";
                  }
                ?>
                <div class="mb-3">
                  <label for="input_ingame" class="form-label">Danh sách In-Game</label>
                  <textarea class="form-control" id="input_ingame" name="input_ingame" rows="3" disabled><?php echo e($ingame); ?></textarea>
                </div>
                <div class="mb-3">
                  <label for="input_user" class="form-label">Tài khoản nhận</label>
                  <input type="text" id="input_user" name="input_user" class="form-control" value="<?php echo e($item->input_user ?? '-KHÔNG CÓ-'); ?>" disabled>
                </div>
              <?php else: ?>
                <div class="mb-3 row">
                  <div class="col-md-4">
                    <label for="input_user" class="form-label">Tài khoản</label>
                    <input type="text" id="input_user" name="input_user" class="form-control" value="<?php echo e($item->input_user ?? '-KHÔNG CÓ-'); ?>" disabled>
                  </div>
                  <div class="col-md-4">
                    <label for="input_pass" class="form-label">Mật khẩu</label>
                    <input type="text" id="input_pass" name="input_pass" class="form-control" value="<?php echo e($item->input_pass ?? '-KHÔNG CÓ-'); ?>" disabled>
                  </div>
                  <div class="col-md-4">
                    <label for="input_auth" class="form-label">Đăng nhập</label>
                    <input type="text" id="input_auth" name="input_auth" class="form-control" value="<?php echo e($item->input_auth ?? '-KHÔNG CÓ-'); ?>" disabled>
                  </div>
                  <div class="col-md-4">
                    <label for="input_extra" class="form-label">Máy chủ ( Server )</label>
                    <input type="text" id="input_extra" name="input_extra" class="form-control" value="<?php echo e($item->input_extra ?? '-KHÔNG CÓ-'); ?>" disabled>
                  </div>
                  <div class="col-md-4">
                    <label for="input_quantity" class="form-label">Số lượng</label>
                    <input type="text" id="input_quantity" name="input_quantity" class="form-control" value="<?php echo e($item->input_quantity ?? '-KHÔNG CÓ-'); ?>" disabled>
                  </div>
                  <div class="col-md-4">
                    <label for="input_contact" class="form-label">Liên hệ</label>
                    <input type="text" id="input_contact" name="input_contact" class="form-control" value="<?php echo e($item->input_contact ?? '-KHÔNG CÓ-'); ?>" disabled>
                  </div>
                </div>
              <?php endif; ?>
              <div class="mb-3">
                <label for="admin_note" class="form-label">Ghi chú admin</label>
                <textarea class="form-control" id="admin_note" name="admin_note" rows="3"><?php echo e($item->admin_note); ?></textarea>
              </div>
              <div class="mb-3">
                <label for="order_note" class="form-label">Ghi chú khách</label>
                <textarea class="form-control" id="order_note" name="order_note" rows="3" disabled><?php echo e($item->order_note); ?></textarea>
              </div>
              <div class="mb-3">
                <label for="status" class="form-label">Trạng thái</label>
                <select class="form-select" id="status" name="status" required>
                  <option value="Pending" <?php echo e($item->status === 'Pending' ? 'selected' : ''); ?>>Chờ xử lý</option>
                  <option value="Processing" <?php echo e($item->status === 'Processing' ? 'selected' : ''); ?>>Đang xử lý</option>
                  <option value="Completed" <?php echo e($item->status === 'Completed' ? 'selected' : ''); ?>>Hoàn thành</option>
                  <option value="Cancelled" <?php echo e($item->status === 'Cancelled' ? 'selected' : ''); ?>>Đã hủy / Hoàn</option>
                </select>
              </div>
              <div class="mb-3">
                <label class="form-label">CTV nhận đơn</label>
                <select name="assigned_to" class="form-select">
                  <option value="">-- Chưa gán CTV --</option>
                  <?php $__currentLoopData = $collaborators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ctv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option
                      value="<?php echo e($ctv->username); ?>"
                      <?php echo e($item->assigned_to === $ctv->username ? 'selected' : ''); ?>

                    >
                      <?php echo e($ctv->username); ?> (ID: <?php echo e($ctv->id); ?>)
                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="mb-3">
                <button class="btn btn-primary">Cập nhật</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.boosting.groups.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Downloads/don1/resources/views/admin/boosting/orders/index.blade.php ENDPATH**/ ?>