<?php $__env->startSection('title', 'Admin: Inventory Variables Management'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý phần thưởng (unit)</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-nowrap datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Đơn vị</th>
              <th>Tên gọi</th>
              <th data-orderable="false">Hình ảnh</th>
              <th>Số lượng</th>
              <th>Tài khoản</th>
              <th>Trạng thái</th>
              <th>Thời gian</th>
              <th>Cập nhật</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $inventories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                if ($item->inventory_var === null && $item->is_active === true) {
                    $item->is_active = false;
                    $item->save();
                }
              ?>

              <tr>
                <td><?php echo e($item->id); ?></td>
                <td><?php echo e($item->inventory_var?->unit ?? '-'); ?></td>
                <td><?php echo e($item->inventory_var?->name ?? '-'); ?></td>
                <td class="text-center">
                  <img src="<?php echo e($item->inventory_var?->image ?? ''); ?>" alt="<?php echo e($item->inventory_var?->name ?? ''); ?>" class="img-fluid" style="width: 30px">
                </td>
                <td><?php echo e(number_format($item->value)); ?> <small class="text-muted text-danger"><?php echo e($item->inventory_var?->unit ?? '-'); ?></small></td>
                <td><?php echo e($item->username); ?></td>
                <td>
                  <?php if($item->is_active): ?>
                    <span class="badge bg-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Phong toả</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->created_at); ?></td>
                <td><?php echo e($item->updated_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/inventory/index.blade.php ENDPATH**/ ?>