<?php $__env->startSection('title', 'Admin: Post Create'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Thêm bài viết mới</div>
    </div>
    <div class="card-body">
      <form action="<?php echo e(route('admin.posts.store')); ?>" method="POST" enctype="multipart/form-data" class="default-form">
        <?php echo csrf_field(); ?>
        <div class="mb-3 row">
          <div class="col-md-6">
            <label for="title" class="form-label">Tiêu đề</label>
            <input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('title')); ?>" required>
          </div>
          <div class="col-md-6">
            <label for="keywords" class="form-label">Từ khoá</label>
            <input type="text" class="form-control" id="keywords" name="meta_data[keywords]" value="<?php echo e(old('keywords')); ?>" required>
          </div>
        </div>
        <div class="mb-3">
          <label for="thumbnail" class="form-label">Ảnh bìa</label>
          <input type="file" class="form-control" id="thumbnail" name="thumbnail" required>
        </div>
        <div class="mb-3">
          <label for="description" class="form-label">Mô tả ngắn</label>
          <textarea class="form-control" id="description" name="description" rows="3"><?php echo e(old('description')); ?></textarea>
        </div>
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="priority" class="fomr-label">Ưu tiên</label>
            <input type="number" class="form-control" id="priority" name="priority" value="<?php echo e(old('priority', 0)); ?>" required>
            <small>Số lớn thì hiện trước</small>
          </div>
          <div class="col-md-6">
            <label for="status" class="form-label">Trạng thái</label>
            <select class="form-select" id="status" name="status" required>
              <option value="1" <?php echo e(old('status') == 1 ? 'selected' : ''); ?>>Hiển thị</option>
              <option value="0" <?php echo e(old('status') == 0 ? 'selected' : ''); ?>>Ẩn</option>
            </select>
          </div>
        </div>
        <div class="mb-3">
          <label for="content" class="form-label">Nội dung</label>
          <textarea class="form-control" id="content" name="content" rows="10" required><?php echo e(old('content')); ?></textarea>
        </div>
        <div class="mb-3 text-center">
          <button class="btn btn-primary-gradient">Thêm bài viết</button>
        </div>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script src="/plugins/ckeditor/ckeditor.js"></script>

  <script>
    $(function() {
      const editor = CKEDITOR.replace('content', {
        extraPlugins: 'notification',
        clipboard_handleImages: false,
        filebrowserImageUploadUrl: '/api/admin/tools/upload?form=ckeditor'
      });

      editor.on('fileUploadRequest', function(evt) {
        var xhr = evt.data.fileLoader.xhr;

        xhr.setRequestHeader('Cache-Control', 'no-cache');
        xhr.setRequestHeader('Authorization', 'Bearer ' + userData.access_token);
      })

    })
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/posts/create.blade.php ENDPATH**/ ?>