
<?php $__env->startSection('title', 'Admin: Boosting Package'); ?>
<?php $__env->startSection('content'); ?>
<div class="card custom-card">
    <div class="card-header justify-content-between">
        <div class="card-title">Thêm sản phẩm vào nhóm</div>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('admin.boosting.packages.store', ['id' => $group->id])); ?>" 
              method="POST" 
              enctype="multipart/form-data" 
              class="default-form">

            <?php echo csrf_field(); ?>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="name" class="form-label">Tên sản phẩm</label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>" placeholder="Tên sản phẩm cần bán" required>
                </div>
                <div class="col-md-6">
                    <label for="price" class="form-label">Giá sản phẩm</label>
                    <input type="text" class="form-control" id="price" name="price" value="<?php echo e(old('price')); ?>" required>
                </div>
            </div>

            <div class="mb-3">
                <label for="status" class="form-label">Trạng thái</label>
                <select class="form-control" id="status" name="status" required>
                    <option value="1">Đang bán</option>
                    <option value="0">Chưa bán</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="descr" class="form-label">Mô tả sản phẩm</label>
                
                
                <textarea class="form-control ckeditor" name="descr" id="descr" rows="5">
                    <?php echo e($page_account_info ?? ''); ?>

                </textarea>
            </div>

            <div class="mb-3 text-center">
                <button class="btn btn-primary">Tạo sản phẩm</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h4>Quản lý sản phẩm của nhóm "<?php echo e($group->name); ?>"</h4>
    </div>
    <div class="card-body">
        <div class="table-responsive theme-scrollbar">
            <table class="display table-bordered table-stripped text-nowrap datatable table text-center">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Thao tác</th>
                        <th>Giá bán</th>
                        <th>Mã sản phẩm</th>
                        <th>Tên Sản Phẩm</th>
                        <th>Trạng thái</th>
                        <th>Ngày thêm</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $group->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.boosting.packages.show', ['id' => $item->id])); ?>" class="btn btn-primary btn-xs sharp me-1 shadow"><i class="fa fa-pencil"></i> sửa</a>
                                <a href="javascript:deleteRow(<?php echo e($item->id); ?>)" class="btn btn-danger btn-xs sharp me-1 shadow"><i class="fa fa-trash"></i> xoá</a>
                            </td>
                            <td><?php echo e(Helper::formatCurrency($item->price)); ?></td>
                            <td>#<?php echo e($item->code); ?></td>
                            <td><?php echo e($item->name); ?></td>
                            <td><?php echo $item->status === true ? '<span class="text-success">Đang Bán</span>' : '<span class="text-danger">Ngưng Bán</span>'; ?></td>
                            <td><?php echo e($item->created_at); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-footer">
        <a href="<?php echo e(route('admin.boosting.groups', ['id' => $group->category_id])); ?>" class="btn btn-danger">
            <i class="fa fa-arrow-left"></i> Quay lại danh sách nhóm
        </a>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const { data: result } = await axios.post('<?php echo e(route('admin.boosting.packages.delete')); ?>', { id })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
</script>


<script src="/plugins/ckeditor/ckeditor.js"></script>

<script>
$(function() {
    const editors = document.querySelectorAll('.ckeditor');

    for (const editor of editors) {
        CKEDITOR.replace(editor, {
            extraPlugins: 'notification',
            clipboard_handleImages: false,
            filebrowserImageUploadUrl: '/api/admin/tools/upload?form=ckeditor'
        });
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Documents/Workspace/known/resources/views/admin/boosting/packages/index.blade.php ENDPATH**/ ?>