<?php $__env->startSection('title', 'Admin: Create Accounts Group'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Sửa nhóm "<?php echo e($group->name); ?>"</div>
    </div>
    <div class="card-body">
      <form action="<?php echo e(route('admin.accounts.groups.update', ['id' => $group->id])); ?>" method="POST" enctype="multipart/form-data" class="default-form">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
          <label for="priority" class="form-label">Ưu tiên</label>
          <input type="number" id="priority" name="priority" class="form-control" value="<?php echo e($group->priority); ?>" required>
        </div>
        <div class="mb-3">
          <label for="image" class="form-label">Ảnh bìa</label>
          <input type="file" id="image" name="image" class="form-control">
        </div>
        <div class="mb-3">
          <label for="game_type" class="form-label">Loại game</label>
          <select name="game_type" id="game_type" class="form-control" required>
            <option value="game-khac">- Game Chung -</option>
            <option value="dot-kich" <?php if($group->game_type === 'dot-kich'): ?> selected <?php endif; ?>>Đột Kích</option>
            <option value="thue-dot-kich" <?php if($group->game_type === 'thue-dot-kich'): ?> selected <?php endif; ?>>Thuê Acc Đột Kích</option>
            <option value="lien-minh" <?php if($group->game_type === 'lien-minh'): ?> selected <?php endif; ?>>Liên Minh Huyền Thoại</option>
          </select>
        </div>
        <div class="mb-3">
          <label for="name" class="form-label">Tên nhóm</label>
          <input type="text" class="form-control" id="name" name="name" placeholder="Nhập tên nhóm" value="<?php echo e($group->name); ?>" required>
        </div>
        <div class="mb-3">
          <label for="descr" class="form-label">Mô tả</label>
          <textarea class="form-control ckeditor" id="descr" name="descr" rows="3" placeholder="Nhập ghi chú"><?php echo e($group->descr); ?></textarea>
        </div>
        <div class="mb-3">
          <label for="descr_seo" class="form-label">Mô tả (gốc dưới)</label>
          <textarea class="form-control ckeditor" id="descr_seo" name="descr_seo" rows="3" placeholder="Nhập ghi chú"><?php echo e($group->descr_seo); ?></textarea>
        </div>
        <div class="mb-3 row">
          <div class="col-md-6">
            <label for="title" class="form-label">Tiêu đề</label>
            <input type="text" class="form-control" id="title" name="meta_seo[title]" placeholder="Nhập tiêu đề" value="<?php echo e($group->meta_seo['title'] ?? ''); ?>">
          </div>
          <div class="col-md-6">
            <label for="keywords" class="form-label">Từ khóa</label>
            <input type="text" class="form-control" id="keywords" name="meta_seo[keywords]" placeholder="Nhập từ khóa" value="<?php echo e($group->meta_seo['keywords'] ?? ''); ?>">
          </div>
        </div>
        <div class="mb-3">
          <label for="status" class="form-label">Trạng thái</label>
          <select class="form-control" id="status" name="status" required>
            <option value="1" <?php if($group->status == 1): ?> selected <?php endif; ?>>Hoạt động</option>
            <option value="0" <?php if($group->status == 0): ?> selected <?php endif; ?>>Tạm đóng</option>
          </select>
        </div>
        <div class="mb-3">
          <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
        </div>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script src="/plugins/ckeditor/ckeditor.js"></script>

  <script>
    $(function() {
      const editor = CKEDITOR.replace('content', {
        extraPlugins: 'notification',
        clipboard_handleImages: false,
        filebrowserImageUploadUrl: '/api/admin/tools/upload?form=ckeditor'
      });

      editor.on('fileUploadRequest', function(evt) {
        var xhr = evt.data.fileLoader.xhr;

        xhr.setRequestHeader('Cache-Control', 'no-cache');
        xhr.setRequestHeader('Authorization', 'Bearer ' + userData.access_token);
      })

    })
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/accounts/groups/edit.blade.php ENDPATH**/ ?>