
<?php $__env->startSection('title', 'Admin: Quản lý Cộng Tác Viên'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý Cộng Tác Viên</div>
    </div>

    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Ưu tiên</th>
              <th>Thao tác</th>
              <th>Tên Cộng Tác Viên</th>
              <th>Số Đơn Đã Hoàn Thành</th>
              <th>Người tạo</th>
              <th>Trạng thái</th>
              <th>Thời gian</th>
            </tr>
          </thead>

          <tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>

                
                <td><?php echo e($item->priority ?? 0); ?></td>

                
                <td>
                  <div class="d-flex">
                    <a href="javascript:void(0)" class="shadow btn btn-primary btn-xs sharp me-1" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>">
                      <i class="fa fa-edit"></i> sửa
                    </a>
                    <a href="<?php echo e(route('admin.boosting.groups', ['id' => $item->id])); ?>" class="shadow btn btn-info btn-xs sharp me-1">
                      <i class="fa fa-eye"></i> xem
                    </a>
                    <a href="javascript:deleteRow(<?php echo e($item->id); ?>)" class="shadow btn btn-danger btn-xs sharp me-1">
                      <i class="fa fa-trash"></i> xoá
                    </a>
                  </div>
                </td>

                
                <td><?php echo e(optional($item->assignedUser)->name ?? 'Không rõ'); ?></td>

                
                <td><?php echo e(\App\Models\GBOrder::where('assigned_to', $item->assigned_to)->where('status', 'completed')->count()); ?></td>

                
                <td><?php echo e($item->created_by ?? 'N/A'); ?></td>

                
                <td>
                  <?php if($item->status == 1): ?>
                    <span class="text-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="text-danger">Tạm đóng</span>
                  <?php endif; ?>
                </td>

                
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>

        </table>
      </div>
    </div>

    <div class="card-footer">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal-create">
        <i class="fa fa-edit"></i> Thêm Cộng Tác Viên Mới
      </button>
    </div>
  </div>

  
  <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Cập nhật Cộng Tác Viên #<?php echo e($item->id); ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body">
            <form action="<?php echo e(route('admin.boosting.categories.update', ['id' => $item->id])); ?>" method="POST" class="default-form">
              <?php echo csrf_field(); ?>

              <div class="mb-3">
                <label class="form-label">Ưu tiên</label>
                <input type="number" class="form-control" name="priority" value="<?php echo e($item->priority ?? 0); ?>">
              </div>

              <div class="mb-3">
                <label class="form-label">Tên Cộng Tác Viên</label>
                <input type="text" class="form-control" name="name" value="<?php echo e(optional($item->assignedUser)->name); ?>">
              </div>

              <div class="mb-3">
                <label class="form-label">Trạng thái</label>
                <select class="form-control" name="status">
                  <option value="1" <?php if($item->status == 1): ?> selected <?php endif; ?>>Hoạt động</option>
                  <option value="0" <?php if($item->status == 0): ?> selected <?php endif; ?>>Tạm đóng</option>
                </select>
              </div>

              <button class="btn btn-primary w-100">Cập nhật</button>
            </form>
          </div>

        </div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

  
  <div class="modal fade" id="modal-create" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">

        <div class="modal-header">
          <h5 class="modal-title">Thêm Cộng Tác Viên</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <form action="<?php echo e(route('admin.boosting.categories.store')); ?>" method="POST" class="default-form">
            <?php echo csrf_field(); ?>

            <div class="mb-3">
              <label class="form-label">Ưu tiên</label>
              <input type="number" class="form-control" name="priority" value="0">
            </div>

            <div class="mb-3">
              <label class="form-label">Tên Cộng Tác Viên</label>
              <input type="text" class="form-control" name="name" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Trạng thái</label>
              <select class="form-control" name="status">
                <option value="1">Hoạt động</option>
                <option value="0">Tạm đóng</option>
              </select>
            </div>

            <button class="btn btn-primary w-100" type="submit">Thêm mới</button>
          </form>
        </div>

      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Hành động này không thể hoàn tác!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const { data: result } = await axios.post('<?php echo e(route('admin.boosting.categories.delete')); ?>', { id })
        Swal.fire('Thành công', result.message, 'success').then(() => window.location.reload())
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Downloads/don1/resources/views/admin/boosting/collaborators/index.blade.php ENDPATH**/ ?>